import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Apps20 = {
  name: 'Apps20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M8 4v4H4V4h4zm2-2H2v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zm8 2v4h-4V4h4zm2-2h-8v8h8V2zM8 14v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zM8 24v4H4v-4h4zm2-2H2v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8zm8 2v4h-4v-4h4zm2-2h-8v8h8v-8z"
      }
    }), children]);
  }
};

export default virtual_Apps20;
