import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Attachment16 = {
  name: 'Attachment16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M14.1 9L7 1.9C5.6.6 3.3.7 2 2.1S.7 5.6 1.9 7l1.6 1.6.8-.8-1.6-1.6c-1-.9-1-2.5-.1-3.5s2.5-1 3.5-.1l.1.1 7.1 7.1c1 .9 1 2.5.1 3.5s-2.5 1-3.5.1l-.1-.1-3.3-3.4c-.6-.5-.6-1.4 0-1.9s1.4-.5 1.9 0l1.7 1.7.8-.7-1.8-1.8c-1-.9-2.5-.9-3.5.1-.9.9-.9 2.4 0 3.3L9 14.1c1.4 1.3 3.7 1.2 5-.2s1.3-3.5.1-4.9z"
      }
    }), children]);
  }
};

export default virtual_Attachment16;
