import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Attachment24 = {
  name: 'Attachment24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M27.1 17.9l-13-13a6.51 6.51 0 0 0-9.2 9.2l3 3 1.41-1.41-3-3a4.5 4.5 0 1 1 6.36-6.36l13 13a4.5 4.5 0 1 1-6.36 6.36l-6.13-6.13A2.5 2.5 0 0 1 16.72 16l3.17 3.17 1.41-1.41s-3.22-3.23-3.25-3.24a4.49 4.49 0 0 0-6.34 6.35l6.19 6.23a6.51 6.51 0 0 0 9.2-9.2z"
      }
    }), children]);
  }
};

export default virtual_Attachment24;
