import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_AudioConsole20 = {
  name: 'AudioConsole20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 20.005h-1v-18h-2v18h-1a2.003 2.003 0 0 0-2 2v2a2.003 2.003 0 0 0 2 2h1v4h2v-4h1a2.003 2.003 0 0 0 2-2v-2a2.003 2.003 0 0 0-2-2zm0 4h-4v-2h4zm-8-10h-1v-12h-2v12h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v10h2v-10h1a2.003 2.003 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8-11h-1v-5h-2v5h-1a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v17h2v-17h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4h-4v-2h4zm-8 10H5v-19H3v19H2a2.002 2.002 0 0 0-2 2v2a2.002 2.002 0 0 0 2 2h1v3h2v-3h1a2.002 2.002 0 0 0 2-2v-2a2.002 2.002 0 0 0-2-2zm0 4H2v-2l4-.001z"
      }
    }), children]);
  }
};

export default virtual_AudioConsole20;
