import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Binoculars20 = {
  name: 'Binoculars20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28 8V5a1 1 0 0 0-1-1h-6a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v2h-4v-2a2 2 0 0 0-2-2V5a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v3a2 2 0 0 0-2 2v12a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 14 22v-2h4v2a2 2 0 0 0 1 1.72V27a1 1 0 0 0 1 1h8a1 1 0 0 0 1-1v-3.28A2 2 0 0 0 30 22V10a2 2 0 0 0-2-2zM11 26H5v-2h6zm1-4H4V10h2V6h4v4h2zm2-4v-4h4v4zm13 8h-6v-2h6zm1-4h-8V10h2V6h4v4h2z"
      }
    }), children]);
  }
};

export default virtual_Binoculars20;
