import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_BrightnessContrast20 = {
  name: 'BrightnessContrast20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M15 2h2v3h-2zm12 13h3v2h-3zM15 27h2v3h-2zM2 15h3v2H2zm3.45-8.117L6.864 5.47l2.122 2.12L7.57 9.004zM23 7.581l2.12-2.121 1.414 1.414-2.121 2.122zm.002 16.835l1.414-1.414 2.122 2.122-1.414 1.414zM5.47 25.13L7.59 23 9 24.42l-2.12 2.12-1.41-1.41zM16 8a8 8 0 1 0 8 8 8 8 0 0 0-8-8zm0 14a6 6 0 0 1 0-12z"
      }
    }), children]);
  }
};

export default virtual_BrightnessContrast20;
