import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Calibrate20 = {
  name: 'Calibrate20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28.83 21.17L25 17.37l.67-.67a1 1 0 0 0 0-1.41l-6-6a1 1 0 0 0-1.41 0l-.79.79-6.76-6.79a1 1 0 0 0-1.41 0l-4 4-.12.15-4 6a1 1 0 0 0 .12 1.26l3 3a1 1 0 0 0 1.42 0L10 13.41l2.09 2.09-4.8 4.79a1 1 0 0 0 0 1.41l2 2a1 1 0 0 0 .71.3 1 1 0 0 0 .52-.15l4.33-2.6 2.44 2.45a1 1 0 0 0 1.41 0l.67-.7 3.79 3.83a4 4 0 0 0 5.66-5.66zM10 10.58l-5 5-1.71-1.71 3.49-5.24L10 5.41l6.09 6.09-2.59 2.58zm8 11l-2.84-2.84-5 3-.74-.74L19 11.41 23.59 16zm9.42 3.83a2 2 0 0 1-2.83 0l-3.8-3.79 2.83-2.83 3.8 3.79a2 2 0 0 1 0 2.83z"
      }
    }), children]);
  }
};

export default virtual_Calibrate20;
