import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Compare24 = {
  name: 'Compare24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M28 6H18V4a2 2 0 0 0-2-2H4a2 2 0 0 0-2 2v20a2 2 0 0 0 2 2h10v2a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2zM4 15h6.17l-2.58 2.59L9 19l5-5-5-5-1.41 1.41L10.17 13H4V4h12v20H4zm12 13v-2a2 2 0 0 0 2-2V8h10v9h-6.17l2.58-2.59L23 13l-5 5 5 5 1.41-1.41L21.83 19H28v9z"
      }
    }), children]);
  }
};

export default virtual_Compare24;
