import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Concept24 = {
  name: 'Concept24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M20.885 19.471a5.96 5.96 0 0 0 0-6.942L23 10.414l1.293 1.293a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414l-4-4a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414L21.586 9l-2.115 2.115a5.96 5.96 0 0 0-6.942 0L10 8.585V2H2v8h6.586l2.529 2.529a5.96 5.96 0 0 0 0 6.942L9 21.586l-1.293-1.293a1 1 0 0 0-1.414 0l-4 4a1 1 0 0 0 0 1.414l4 4a1 1 0 0 0 1.414 0l4-4a1 1 0 0 0 0-1.414L10.414 23l2.115-2.115a5.96 5.96 0 0 0 6.942 0L22 23.415V30h8v-8h-6.586zM25 4.414L27.586 7 25 9.586 22.414 7zM7 27.586L4.414 25 7 22.414 9.586 25zM8 8H4V4h4zm4 8a4 4 0 1 1 4 4 4.005 4.005 0 0 1-4-4zm12 8h4v4h-4z"
      }
    }), children]);
  }
};

export default virtual_Concept24;
