import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_CopyFile20 = {
  name: 'CopyFile20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M27.435 14.699l-6.058-6.121A1.949 1.949 0 0 0 19.998 8H12a2.002 2.002 0 0 0-2 2v19a2.002 2.002 0 0 0 2 2h14a2.002 2.002 0 0 0 2-2V16.077a1.976 1.976 0 0 0-.565-1.378zM20 10.03L25.924 16H20zM12 29V10h6v6a2.002 2.002 0 0 0 2 2h6l.001 11z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M6 18H4V4a2.002 2.002 0 0 1 2-2h14v2H6z"
      }
    }), children]);
  }
};

export default virtual_CopyFile20;
