import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_DataConnected16 = {
  name: 'DataConnected16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 30h-6v-2h4V4h-4V2h6v28z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M24.91 19.59a4.51 4.51 0 0 0-2.66-3.24 4.55 4.55 0 0 0-3.5 0 4.94 4.94 0 0 0-.64.35l-2.81-2.81a4.53 4.53 0 1 0-1.41 1.41l2.81 2.81a4.48 4.48 0 0 0-.61 3.3 4.51 4.51 0 0 0 2.66 3.24 4.55 4.55 0 0 0 3.5 0 4.51 4.51 0 0 0 2.66-3.24 4.65 4.65 0 0 0 0-1.82zM11.5 14a2.5 2.5 0 1 1 2.5-2.5 2.5 2.5 0 0 1-2.5 2.5z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M8 30H2V2h6v2H4v24h4v2z"
      }
    }), children]);
  }
};

export default virtual_DataConnected16;
