import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_DataVis_124 = {
  name: 'DataVis_124',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M26 22a3.955 3.955 0 0 0-2.02.567l-3.813-3.814a4.965 4.965 0 0 0 0-5.506l2.547-2.547A3.028 3.028 0 1 0 21.3 9.286l-2.547 2.547a4.965 4.965 0 0 0-5.506 0L9.433 8.019A3.955 3.955 0 0 0 10 6a4 4 0 1 0-4 4 3.955 3.955 0 0 0 2.02-.567l3.813 3.814a4.965 4.965 0 0 0 0 5.506l-3.814 3.814A3.956 3.956 0 0 0 6 22a4 4 0 1 0 4 4 3.955 3.955 0 0 0-.567-2.02l3.814-3.813a4.969 4.969 0 0 0 1.753.732v3.285a3 3 0 1 0 2 0v-3.285a4.969 4.969 0 0 0 1.753-.732l3.814 3.814A3.955 3.955 0 0 0 22 26a4 4 0 1 0 4-4zm-10-9a3 3 0 1 1-3 3 3.003 3.003 0 0 1 3-3zM4 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm20 0a2 2 0 1 1 2-2 2.003 2.003 0 0 1-2 2z"
      }
    }), children]);
  }
};

export default virtual_DataVis_124;
