import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Diagram24 = {
  name: 'Diagram24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M13 30a11 11 0 0 1 0-22 1 1 0 0 1 1 1v9h9a1 1 0 0 1 1 1 11 11 0 0 1-11 11zm-1-19.94A9 9 0 1 0 21.94 20H14a2 2 0 0 1-2-2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M28 14h-9a2 2 0 0 1-2-2V3a1 1 0 0 1 1-1 11 11 0 0 1 11 11 1 1 0 0 1-1 1zm-9-2h7.94A9 9 0 0 0 19 4.06z"
      }
    }), children]);
  }
};

export default virtual_Diagram24;
