import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Draw32 = {
  name: 'Draw32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M19.14 28a3.42 3.42 0 0 1-2.42-5.85L21.86 17a1.42 1.42 0 1 0-2-2L13 21.85a3.5 3.5 0 0 1-4.85 0 3.43 3.43 0 0 1 0-4.84l8.58-8.58a1.42 1.42 0 1 0-2-2L6.41 14.7 5 13.3 13.29 5a3.43 3.43 0 0 1 4.84 4.85l-8.57 8.57a1.42 1.42 0 0 0 0 2 1.45 1.45 0 0 0 2 0l6.86-6.86a3.43 3.43 0 1 1 4.85 4.84l-5.15 5.15a1.42 1.42 0 0 0 2 2l4.44-4.43L26 22.56 21.56 27a3.38 3.38 0 0 1-2.42 1z"
      }
    }), children]);
  }
};

export default virtual_Draw32;
