import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_EarthAmericas32 = {
  name: 'EarthAmericas32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 16a14.031 14.031 0 1 0-7.14 12.191l.117.026.024-.111A13.998 13.998 0 0 0 30 16zM4 16a11.937 11.937 0 0 1 .395-3h4.243l4.992 4.16-1.91 2.546a2.009 2.009 0 0 0 .186 2.614L14 24.414v3.405A12.01 12.01 0 0 1 4 16zm9.32 4.906l3.05-4.066L9.362 11H5.106a11.962 11.962 0 0 1 17.778-4.814L22.279 8h-5.693l-3.043 3.043 9.354 8.313-1.649 7.419A11.903 11.903 0 0 1 16 28v-4.414zm10.315 4.344l1.213-5.46a2 2 0 0 0-.623-1.927l-7.768-6.906.957-.957h4.865a1.998 1.998 0 0 0 1.898-1.368l.353-1.06a11.978 11.978 0 0 1-.895 17.678z"
      }
    }), children]);
  }
};

export default virtual_EarthAmericas32;
