import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Earth16 = {
  name: 'Earth16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14.016 14.016 0 0 0 16 2zm5 3.106a12.014 12.014 0 0 1 2.916 1.899L23.503 8H21zm-7.622 22.597A11.976 11.976 0 0 1 8.116 6.976L9.465 9h3.342l-1.5 4H7.28l-1.382 4.148L8.465 21h5l1.432 2.147zM16 28c-.203 0-.402-.02-.603-.03l1.397-4.19a1.988 1.988 0 0 0-.233-1.741l-1.432-2.148A1.996 1.996 0 0 0 13.465 19h-3.93l-1.432-2.148L8.721 15H11v2h2v-2.819l2.936-7.83-1.872-.702L13.557 7h-3.022l-.807-1.21A11.794 11.794 0 0 1 19 4.394V8a2.002 2.002 0 0 0 2 2h2.586A1.986 1.986 0 0 0 25 9.414l.14-.14.282-.68A11.981 11.981 0 0 1 27.3 12h-4.701a1.993 1.993 0 0 0-1.972 1.665l-.597 3.441a1.99 1.99 0 0 0 .991 2.086l2.165 1.464 1.458 3.646A11.958 11.958 0 0 1 16 28zm8.815-8.656L22.1 17.509l-.1-.06.599-3.449h5.22a11.743 11.743 0 0 1-1.744 8.495z"
      }
    }), children]);
  }
};

export default virtual_Earth16;
