import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_EditOff16 = {
  name: 'EditOff16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M15 14.3L1.7 1l-.7.7 5 5-4 4V14h3.2l4-4 5 5 .8-.7zM4.8 13H3v-1.8l3.8-3.8 1.8 1.8L4.8 13zm9.9-9.9l-1.8-1.8c-.4-.4-1-.4-1.4 0l-4 4 .7.7L10 4.2 11.8 6 10 7.8l.7.7 4-4c.4-.4.4-1 0-1.4zm-2.2 2.2l-1.8-1.8L12.2 2 14 3.8l-1.5 1.5z"
      }
    }), children]);
  }
};

export default virtual_EditOff16;
