import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_EditOff24 = {
  name: 'EditOff24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 28.59L3.41 2 2 3.41 12.09 13.5 4 21.59V28h6.41l8.09-8.09L28.59 30zM9.59 26H6v-3.59l7.5-7.5 3.59 3.59zM29.41 6.17l-3.58-3.58a2 2 0 0 0-2.83 0l-8.08 8.08 1.41 1.41L20 8.41 23.59 12l-3.67 3.67 1.41 1.41L29.41 9a2 2 0 0 0 0-2.83zM25 10.59L21.41 7l3-3L28 7.59z"
      }
    }), children]);
  }
};

export default virtual_EditOff24;
