import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_EdtLoop16 = {
  name: 'EdtLoop16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M23.625 22.587a6.129 6.129 0 0 1-4.5-1.9l-3.1-3.2-3.1 3.2a6.458 6.458 0 0 1-9.1 0 7.028 7.028 0 0 1-1.8-4.7 6.655 6.655 0 0 1 1.9-4.7 6.338 6.338 0 0 1 9 0l3.1 3.2 3.1-3.2a6.338 6.338 0 0 1 9 0 6.828 6.828 0 0 1 0 9.4 6.542 6.542 0 0 1-4.5 1.9zm-6.2-6.6l3.1 3.3a4.406 4.406 0 0 0 6.2 0 4.908 4.908 0 0 0 0-6.6 4.406 4.406 0 0 0-6.2 0zm-9-4.6a4.158 4.158 0 0 0-3.1 1.3 4.838 4.838 0 0 0 0 6.6 4.406 4.406 0 0 0 6.2 0l3.1-3.3-3.1-3.3a4.77 4.77 0 0 0-3.1-1.3z"
      }
    }), children]);
  }
};

export default virtual_EdtLoop16;
