import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Export16 = {
  name: 'Export16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M13 12v2H3v-2H2v2c0 .6.4 1 1 1h10c.6 0 1-.4 1-1v-2h-1zM3 6l.7.7 3.8-3.8V12h1V2.9l3.8 3.8.7-.7-5-5z"
      }
    }), children]);
  }
};

export default virtual_Export16;
