import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_FaceDizzyFilled24 = {
  name: 'FaceDizzyFilled24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 2a14 14 0 1 0 14 14A14 14 0 0 0 16 2zM9 16.41L7.59 15l2-2-2-2L9 9.59l2 2 2-2L14.41 11l-2 2 2 2L13 16.41l-2-2zM16 25a3 3 0 1 1 3-3 3 3 0 0 1-3 3zm8.41-10L23 16.41l-2-2-2 2L17.59 15l2-2-2-2L19 9.59l2 2 2-2L24.41 11l-2 2z"
      }
    }), children]);
  }
};

export default virtual_FaceDizzyFilled24;
