import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Function24 = {
  name: 'Function24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M8.5 30a2.5 2.5 0 0 1 0-5c.63-.07 2.35-1.53 2.49-7.22l-1.78-.45a2.92 2.92 0 0 1 0-5.66l1.79-.46C11.55 4 19.32 2 23.5 2a2.5 2.5 0 0 1 0 5c-.08 0-2.23.15-2.48 4.22l1.77.45a2.92 2.92 0 0 1 0 5.66l-1.79.46C20.49 29.86 8.62 30 8.5 30zm15-26c-.43 0-10.5.11-10.5 8v.78l-3.3.83a.92.92 0 0 0 0 1.78l3.3.83V17c0 9.72-4 10-4.5 10a.5.5 0 0 0 0 1c.43 0 10.5-.17 10.5-11v-.78l3.3-.83a.92.92 0 0 0 0-1.78l-3.3-.83V12c0-6.92 4.46-7 4.5-7a.5.5 0 0 0 0-1z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M4.15 23.46a14 14 0 0 1 6.46-20.38l.77 1.84A12 12 0 0 0 5.85 22.4zm17.24 5.46l-.77-1.84a12 12 0 0 0 5.49-17.54l1.69-1.08a14 14 0 0 1-6.41 20.46z"
      }
    }), children]);
  }
};

export default virtual_Function24;
