import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Integration32 = {
  name: 'Integration32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29.88 15.52l-6-11A1 1 0 0 0 23 4H9a1 1 0 0 0-.88.52l-6 11a1 1 0 0 0 0 1l6 11A1 1 0 0 0 9 28h14a1 1 0 0 0 .88-.52l6-11a1 1 0 0 0 0-.96zM22.93 7l4.39 8h-9.5zM16 14.14L10.82 6h10.36zM9.07 7l5.11 8h-9.5zM4.68 17h9.5l-5.11 8zm11.32.86L21.18 26H10.82zM22.93 25l-5.11-8h9.5z"
      }
    }), children]);
  }
};

export default virtual_Integration32;
