import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_LetterWw20 = {
  name: 'LetterWw20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M24.3 13l-.91 8.61L22 13h-2l-1.39 8.61L17.7 13H16l1.36 10h2.28L21 14.63 22.36 23h2.28L26 13h-1.7zM12.21 9l-.34 8-.26 4.54L11.2 18l-.68-5.46H8.5L7.82 18l-.41 3.54L7.16 17l-.35-8h-1.8l1 14h2.27l.76-4.93L9.5 14l.01-.03.01.03.46 4.07.76 4.93h2.27l1-14h-1.8z"
      }
    }), children]);
  }
};

export default virtual_LetterWw20;
