import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Location20 = {
  name: 'Location20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M16 10a3 3 0 1 1-3 3 3 3 0 0 1 3-3m0-2a5 5 0 1 0 5 5 5 5 0 0 0-5-5z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M16 4a8.88 8.88 0 0 1 9 8.71 8.47 8.47 0 0 1-1.79 5.21L16 28.46 8.85 18A8.47 8.47 0 0 1 7 12.71 8.88 8.88 0 0 1 16 4m0-2A10.86 10.86 0 0 0 5 12.71a10.53 10.53 0 0 0 2.2 6.43L16 32l8.8-12.86a10.53 10.53 0 0 0 2.2-6.43A10.86 10.86 0 0 0 16 2z"
      }
    }), children]);
  }
};

export default virtual_Location20;
