import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_LogoGlassdoor16 = {
  name: 'LogoGlassdoor16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M10.828 28h10.344a3.43 3.43 0 0 0 3.43-3.43V10.33h-3.43v14.24H7.398a3.43 3.43 0 0 0 3.43 3.43z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M21.172 4H10.828a3.43 3.43 0 0 0-3.43 3.43v14.24h3.43V7.43h13.774A3.43 3.43 0 0 0 21.172 4z"
      }
    }), children]);
  }
};

export default virtual_LogoGlassdoor16;
