import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_MedicationAlert24 = {
  name: 'MedicationAlert24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M22 19h2v5h-2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M23 31a8 8 0 1 1 8-8 8 8 0 0 1-8 8zm0-14a6 6 0 1 0 6 6 6 6 0 0 0-6-6z"
      }
    }), createElement('circle', {
      attrs: {
        "cx": "23",
        "cy": "26",
        "r": "1"
      }
    }), createElement('path', {
      attrs: {
        "d": "M20 2H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2v18a2 2 0 0 0 2 2h8v-2H6v-2h5V12H6v-2h12v3h2v-3a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2zM9 14v10H6V14zM4 8V4h16v4z"
      }
    }), children]);
  }
};

export default virtual_MedicationAlert24;
