import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Misuse20 = {
  name: 'Misuse20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 20 20',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M10 1c-4.9 0-9 4.1-9 9s4.1 9 9 9 9-4 9-9-4-9-9-9zm3.5 13.5L10 11l-3.5 3.5-1-1L9 10 5.5 6.5l1-1L10 9l3.5-3.5 1 1L11 10l3.5 3.5-1 1z"
      }
    }), createElement('path', {
      attrs: {
        "fill": "none",
        "d": "M13.5 14.5L10 11l-3.5 3.5-1-1L9 10 5.5 6.5l1-1L10 9l3.5-3.5 1 1L11 10l3.5 3.5-1 1z",
        "data-icon-path": "inner-path",
        "opacity": "0"
      }
    }), children]);
  }
};

export default virtual_Misuse20;
