import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_ModelReference32 = {
  name: 'ModelReference32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M4 21v2h3.586L2 28.586 3.414 30 9 24.414V28h2v-7H4z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M23.5 4h-15l-6 8-.784 1.045L6.877 19l1.324-1.526L5.19 14h5.112L16 29.527l14.284-16.482zm3.5 8h-5.446l-3.75-6H22.5zm-7.804 0h-6.392L16 6.887zM5 12l4.5-6h4.696l-3.75 6zm10.999 11.721L12.432 14h7.136zm1.944.51L21.698 14h5.112z"
      }
    }), children]);
  }
};

export default virtual_ModelReference32;
