import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Network_432 = {
  name: 'Network_432',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('circle', {
      attrs: {
        "cx": "21",
        "cy": "26",
        "r": "2"
      }
    }), createElement('circle', {
      attrs: {
        "cx": "21",
        "cy": "6",
        "r": "2"
      }
    }), createElement('circle', {
      attrs: {
        "cx": "4",
        "cy": "16",
        "r": "2"
      }
    }), createElement('path', {
      attrs: {
        "d": "M28 12a3.996 3.996 0 0 0-3.858 3h-4.284a3.966 3.966 0 0 0-5.491-2.643l-3.177-3.97A3.963 3.963 0 0 0 12 6a4 4 0 1 0-4 4 3.96 3.96 0 0 0 1.634-.357l3.176 3.97a3.924 3.924 0 0 0 0 4.774l-3.176 3.97A3.96 3.96 0 0 0 8 22a4 4 0 1 0 4 4 3.962 3.962 0 0 0-.81-2.387l3.176-3.97A3.966 3.966 0 0 0 19.858 17h4.284A3.993 3.993 0 1 0 28 12zM6 6a2 2 0 1 1 2 2 2.002 2.002 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm8-10a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2zm12 0a2 2 0 1 1 2-2 2.002 2.002 0 0 1-2 2z"
      }
    }), children]);
  }
};

export default virtual_Network_432;
