import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_NotificationOffFilled16 = {
  name: 'NotificationOffFilled16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M26 17.6V13a10 10 0 0 0-1.09-4.5L30 3.41 28.59 2 2 28.59 3.41 30l5-5H11a5 5 0 0 0 10 0h7a.94.94 0 0 0 1-1v-3a.91.91 0 0 0-.3-.7zM16 28a3 3 0 0 1-3-3h6a3 3 0 0 1-3 3zm5.63-23.28A9.78 9.78 0 0 0 17 3V1h-2v2a10.15 10.15 0 0 0-9 10v4.6l-2.7 2.7a.91.91 0 0 0-.3.7v2.34z"
      }
    }), children]);
  }
};

export default virtual_NotificationOffFilled16;
