import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_NotificationOff16 = {
  name: 'NotificationOff16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M2.5 11.5v-.8l1.3-1.4c.1 0 .2-.2.2-.3V6.5c0-2.2 1.8-4 4-4 .9 0 1.8.3 2.5.9l.7-.7c-.7-.7-1.7-1.1-2.7-1.2v-1h-1v1C5 1.8 3 3.9 3 6.5v2.3l-1.4 1.3c-.1.1-.2.2-.1.4v1h1zM13 8.8V6.5c0-.8-.2-1.6-.5-2.2L15 1.7l-.7-.7L1 14.3l.7.7 2.5-2.5h1.3C5.5 13.9 6.6 15 8 15s2.5-1.1 2.5-2.5H14c.3 0 .5-.2.5-.4v-1.6c0-.1-.1-.3-.1-.4L13 8.8zM8 14c-.8 0-1.5-.7-1.5-1.5h3c0 .8-.7 1.5-1.5 1.5zm5.5-2.5H5.2L11.7 5c.2.5.3 1 .3 1.5V9c0 .1.1.3.1.4l1.4 1.3v.8z"
      }
    }), children]);
  }
};

export default virtual_NotificationOff16;
