import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_PlayOutline16 = {
  name: 'PlayOutline16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M8 2c3.3 0 6 2.7 6 6s-2.7 6-6 6-6-2.7-6-6 2.7-6 6-6m0-1C4.1 1 1 4.1 1 8s3.1 7 7 7 7-3.1 7-7-3.1-7-7-7z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M6 11.5c-.1 0-.2 0-.3-.1-.2-.1-.2-.3-.2-.4V5c0-.2.1-.3.2-.4.2-.1.3-.1.5 0l5.5 3c.3.1.4.4.2.6 0 .1-.1.2-.2.2l-5.5 3c0 .1-.1.1-.2.1zm.5-5.7v4.3l4-2.2-4-2.1z"
      }
    }), children]);
  }
};

export default virtual_PlayOutline16;
