import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Power16 = {
  name: 'Power16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 16 16',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M11.2 2.9l-.5.9c2.6 1.5 3.5 4.9 2 7.5s-4.9 3.5-7.5 2-3.5-4.9-2-7.5c.5-.8 1.2-1.5 2-2l-.4-.9C1.7 4.7.6 8.7 2.4 11.8s5.8 4.2 8.9 2.4 4.2-5.8 2.4-8.9c-.6-1-1.5-1.9-2.5-2.4z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M7.5 1h1v7h-1z"
      }
    }), children]);
  }
};

export default virtual_Power16;
