import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_TextCreation16 = {
  name: 'TextCreation16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M27 22.14V9.86A4 4 0 1 0 22.14 5H9.86A4 4 0 1 0 5 9.86v12.28A4 4 0 1 0 9.86 27h12.28A4 4 0 1 0 27 22.14zM26 4a2 2 0 1 1-2 2 2 2 0 0 1 2-2zM4 6a2 2 0 1 1 2 2 2 2 0 0 1-2-2zm2 22a2 2 0 1 1 2-2 2 2 0 0 1-2 2zm16.14-3H9.86A4 4 0 0 0 7 22.14V9.86A4 4 0 0 0 9.86 7h12.28A4 4 0 0 0 25 9.86v12.28A4 4 0 0 0 22.14 25zM26 28a2 2 0 1 1 2-2 2 2 0 0 1-2 2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M21 11H11v2h4v9h2v-9h4v-2z"
      }
    }), children]);
  }
};

export default virtual_TextCreation16;
