import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_ThumbsUp20 = {
  name: 'ThumbsUp20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M26 11h-6V6a3.64 3.64 0 0 0-3.24-4A3.22 3.22 0 0 0 16 2h-1.57A1.51 1.51 0 0 0 13 3.17v.12l-1 6.34L8.46 15H2v14h19c7.44 0 9-4.35 9-8v-6a3.64 3.64 0 0 0-3.24-4 3.22 3.22 0 0 0-.76 0zM8 27H4V17h4zm20-6c0 4.09-2.22 6-7 6H10V16.3l4-5.93.73-5.37.14-1H16c1.44 0 2 .56 2 2v7h8c1.44 0 2 .56 2 2z"
      }
    }), children]);
  }
};

export default virtual_ThumbsUp20;
