import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_Undo20 = {
  name: 'Undo20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 20 20',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M15 9.3c1.5 0 2.8 1.3 2.8 2.7 0 1.5-1.3 2.7-2.8 2.7h-4V16h4c2.3 0 4-1.7 4-4 0-2.2-1.8-4-4-4H3.4l2.5-2.5-.9-.9-4 4 4 4 .9-.9-2.5-2.4H15z"
      }
    }), children]);
  }
};

export default virtual_Undo20;
