import { _ as _objectSpread2, a as _defineProperty } from '../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_WarningAltInvertedFilled32 = {
  name: 'WarningAltInvertedFilled32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29.86 2.49A1 1 0 0 0 29 2H3a1.002 1.002 0 0 0-.88 1.478l13 25.037a1.04 1.04 0 0 0 1.759 0l13-25.037a1.003 1.003 0 0 0-.02-.989zM14.874 5h2.25v10h-2.25zM16 21a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 16 21z"
      }
    }), createElement('path', {
      attrs: {
        "fill": "none",
        "d": "M14.875 5h2.25v10h-2.25zM16 21a1.5 1.5 0 1 1 1.5-1.5A1.5 1.5 0 0 1 16 21z",
        "data-icon-path": "inner-path"
      }
    }), children]);
  }
};

export default virtual_WarningAltInvertedFilled32;
