import { _ as _objectSpread2, a as _defineProperty } from '../../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_WatsonHealthArrowAnnotation16 = {
  name: 'WatsonHealthArrowAnnotation16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M13.71 12.29L7.42 6H14V4H4v9.99l2 .02v-6.6l6.29 6.29 1.42-1.41zM28 10H18v2h10v16H12V18h-2v10a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V12a2 2 0 0 0-2-2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M19 25h2v-7h3v-2h-8v2h3v7z"
      }
    }), children]);
  }
};

export default virtual_WatsonHealthArrowAnnotation16;
