import { _ as _objectSpread2, a as _defineProperty } from '../../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_WatsonHealthCobbAngle32 = {
  name: 'WatsonHealthCobbAngle32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M20 17v-2a2 2 0 0 0-2-2h-8a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zm-10-2h8v2h-8zm13.42 9.48A2 2 0 0 0 21 23.06l-7.73 2.07a2 2 0 0 0-1.42 2.44l.52 1.93a2 2 0 0 0 1.9 1.5 3 3 0 0 0 .52-.07l7.73-2.07a2 2 0 0 0 1.41-2.45zM14.27 29l-.51-1.94L21.48 25l.52 1.92zM13.24 6.86L21 8.93a2.24 2.24 0 0 0 .51.07 2 2 0 0 0 1.94-1.48L24 5.58a2 2 0 0 0-1.41-2.45l-7.8-2.07a2 2 0 0 0-2.45 1.41l-.52 1.93a2 2 0 0 0 1.42 2.44zm1-3.86L22 5.07 21.48 7l-7.72-2.07zM14 21h2v2h-2zm0-12h2v2h-2z"
      }
    }), children]);
  }
};

export default virtual_WatsonHealthCobbAngle32;
