import { _ as _objectSpread2, a as _defineProperty } from '../../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_WatsonHealthLaunchStudy_120 = {
  name: 'WatsonHealthLaunchStudy_120',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('circle', {
      attrs: {
        "cx": "23",
        "cy": "25",
        "r": "1"
      }
    }), createElement('path', {
      attrs: {
        "d": "M26 22v6H6v-6h20m0-2H6a2 2 0 0 0-2 2v6a2 2 0 0 0 2 2h20a2 2 0 0 0 2-2v-6a2 2 0 0 0-2-2zm-5.41-9.41L17 14.17V2h-2v12.17l-3.59-3.58L10 12l6 6 6-6-1.41-1.41z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M8 24h12v2H8z"
      }
    }), children]);
  }
};

export default virtual_WatsonHealthLaunchStudy_120;
