import { _ as _objectSpread2, a as _defineProperty } from '../../chunk-75bb93d0.js';
import { getAttributes } from '@carbon/icon-helpers';

var virtual_WatsonHealthPetImageB24 = {
  name: 'WatsonHealthPetImageB24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = getAttributes(_objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = _defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M19 21h2v3h-2zm0-21h2v3h-2zM8 11h3v2H8zm21 0h3v2h-3zM10.816 4.216l1.4-1.4 2.122 2.12-1.4 1.401zm14.862 14.84l1.4-1.4 2.121 2.121-1.4 1.4zm-14.851.717l2.121-2.121 1.4 1.4-2.12 2.121zm14.84-14.847l2.122-2.122 1.4 1.4-2.122 2.122zM20 5a7 7 0 1 0 7 7 7 7 0 0 0-7-7zm0 12a5 5 0 0 1 0-10zM5 18H0v14h5a3 3 0 0 0 3-3v-2a3 3 0 0 0-.78-2A3 3 0 0 0 8 23v-2a3 3 0 0 0-3-3zm-3 2h3a1 1 0 0 1 1 1v2a1 1 0 0 1-1 1H2zm4 9a1 1 0 0 1-1 1H2v-4h3a1 1 0 0 1 1 1zM2 2h7V0H0v9h2V2z"
      }
    }), children]);
  }
};

export default virtual_WatsonHealthPetImageB24;
