'use strict';

var __chunk_1 = require('../../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_QComposerEdit20 = {
  name: 'QComposerEdit20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M25.82 10H30V8h-4.18a3 3 0 0 0-5.64 0H13V5H5v3H2v2h3v3h8v-3h7.18A3 3 0 0 0 22 11.82v7.32A4 4 0 0 0 19.14 22H2v2h17.14a4 4 0 0 0 7.72 0H30v-2h-3.14A4 4 0 0 0 24 19.14v-7.32A3 3 0 0 0 25.82 10zM11 11H7V7h4zm14 12a2 2 0 1 1-2-2 2 2 0 0 1 2 2z"
      }
    }), children]);
  }
};

module.exports = virtual_QComposerEdit20;
