'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Sdk32 = {
  name: 'Sdk32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M30 9h-2.1L24 15.6V9h-2v14h2v-4.3l.9-1.5 3 5.8H30l-3.9-7.6L30 9zM16 23h-4V9h4a4.012 4.012 0 0 1 4 4v6a4.012 4.012 0 0 1-4 4zm-2-2h2a2.006 2.006 0 0 0 2-2v-6a2.006 2.006 0 0 0-2-2h-2zm-6 2H2v-2h6v-4H4a2.006 2.006 0 0 1-2-2v-4a2.006 2.006 0 0 1 2-2h6v2H4v4h4a2.006 2.006 0 0 1 2 2v4a2.006 2.006 0 0 1-2 2z"
      }
    }), children]);
  }
};

module.exports = virtual_Sdk32;
