'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Usb16 = {
  name: 'Usb16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M24 15V6a2 2 0 0 0-2-2H10a2 2 0 0 0-2 2v9a2 2 0 0 0-2 2v11h2V17h16v11h2V17a2 2 0 0 0-2-2zM10 6h12v9H10z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M12 10h3v2h-3zm5 0h3v2h-3z"
      }
    }), children]);
  }
};

module.exports = virtual_Usb16;
