'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Wmv20 = {
  name: 'Wmv20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M29 9l-2 13-2-13h-2l2.52 14h2.96L31 9h-2zM19 9l-1.52 5-.48 1.98-.46-1.98L15 9h-2v14h2v-8l-.16-2 .58 2L17 19.63 18.58 15l.58-2-.16 2v8h2V9h-2zM9.2 9l-.34 8-.26 4.54L8.19 18l-.68-5.46H5.49L4.81 18l-.41 3.54L4.14 17 3.8 9H2l1 14h2.27l.76-4.93.46-4.07.01-.03.01.03.46 4.07.76 4.93H10l1-14H9.2z"
      }
    }), children]);
  }
};

module.exports = virtual_Wmv20;
