'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Asleep32 = {
  name: 'Asleep32',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '32',
      height: '32',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M13.49 5.41a15.08 15.08 0 0 0 11.6 18.2 11.09 11.09 0 0 1-8 3.39h-.42a11.1 11.1 0 0 1-3.2-21.59M15 3h-.2a13.09 13.09 0 0 0 1.82 26h.49a13.08 13.08 0 0 0 10.71-5.56 1 1 0 0 0-.82-1.56 13.08 13.08 0 0 1-11.12-17.5A1 1 0 0 0 15 3z"
      }
    }), children]);
  }
};

module.exports = virtual_Asleep32;
