'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_Asset16 = {
  name: 'Asset16',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '16',
      height: '16',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M12.075 24a4 4 0 1 1 4-4 4.004 4.004 0 0 1-4 4zm0-6a2 2 0 1 0 2 2 2.002 2.002 0 0 0-2-2z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M30 6a4.004 4.004 0 0 0-4-4 3.949 3.949 0 0 0-1.854.477l-16.389 8.48a9.992 9.992 0 1 0 13.309 13.236l8.49-16.4A3.95 3.95 0 0 0 30 6zm-4-2a2 2 0 1 1-2 2 2.002 2.002 0 0 1 2-2zm-3.98 1.808c-.004.065-.02.126-.02.192a4.004 4.004 0 0 0 4 4c.065 0 .124-.016.188-.019l-4.332 8.362a10.017 10.017 0 0 0-8.215-8.196zM12 28a8 8 0 1 1 8-8 8.01 8.01 0 0 1-8 8z"
      }
    }), children]);
  }
};

module.exports = virtual_Asset16;
