'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_AugmentedReality20 = {
  name: 'AugmentedReality20',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '20',
      height: '20',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M27.447 9.105l-6-3a1 1 0 0 0-.894 0l-6 3A1 1 0 0 0 14 10v7a1 1 0 0 0 .553.894l6 3a1.001 1.001 0 0 0 .894 0l6-3A1 1 0 0 0 28 17v-7a1 1 0 0 0-.553-.895zM21 8.118L24.764 10 21 11.882 17.236 10zm-5 3.5l4 2v4.764l-4-2zm6 6.764v-4.764l4-2v4.764z"
      }
    }), createElement('circle', {
      attrs: {
        "cx": "13.5",
        "cy": "24.5",
        "r": "1.5"
      }
    }), createElement('path', {
      attrs: {
        "d": "M20 30H7a2.002 2.002 0 0 1-2-2V4a2.002 2.002 0 0 1 2-2h13v2H7v24h13v-4h2v4a2.002 2.002 0 0 1-2 2z"
      }
    }), children]);
  }
};

module.exports = virtual_AugmentedReality20;
