'use strict';

var __chunk_1 = require('../chunk-d2faeea1.js');
var iconHelpers = require('@carbon/icon-helpers');

var virtual_BatteryQuarter24 = {
  name: 'BatteryQuarter24',
  functional: true,
  // We use title as the prop name as it is not a valid attribute for an SVG
  // HTML element
  props: ['title'],
  render: function render(createElement, context) {
    var children = context.children,
        data = context.data,
        listeners = context.listeners,
        props = context.props;
    var attrs = iconHelpers.getAttributes(__chunk_1._objectSpread2({
      width: '24',
      height: '24',
      viewBox: '0 0 32 32',
      preserveAspectRatio: 'xMidYMid meet',
      xmlns: 'http://www.w3.org/2000/svg',
      // Special case here, we need to coordinate that we are using title,
      // potentially, to get the right focus attributes
      title: props.title
    }, data.attrs));
    var svgData = {
      attrs: attrs,
      on: listeners
    };

    if (data.staticClass) {
      svgData.class = __chunk_1._defineProperty({}, data.staticClass, true);
    }

    if (data.class) {
      svgData.class[data.class] = true;
    }

    return createElement('svg', svgData, [props.title && createElement('title', null, props.title), createElement('path', {
      attrs: {
        "d": "M24 24H6a2.002 2.002 0 0 1-2-2V10a2.002 2.002 0 0 1 2-2h18a2.002 2.002 0 0 1 2 2v1h1a2.002 2.002 0 0 1 2 2v6a2.003 2.003 0 0 1-2 2h-1v1a2.003 2.003 0 0 1-2 2zM6 10v12h18v-3h3v-6h-3v-3z"
      }
    }), createElement('path', {
      attrs: {
        "d": "M12 12v8H8v-8z"
      }
    }), children]);
  }
};

module.exports = virtual_BatteryQuarter24;
